<?php

namespace App\Traits;

trait HttpResponses
{
    public function success(
        string $message = 'Request successful.',
        mixed $data = null,
        string $responseCode = '000',
        int $httpCode = 200
    ) {
        $res = [
            'status'       => 'success',
            'responseCode' => $responseCode,
            'message'      => $message,
        ];

        if (!is_null($data)) {
            $res['data'] = $data;
        }

        return response()->json($res, $httpCode);
    }

    public function error(
        string $message = 'Request failed.',
        string|int $responseCode = '400',
        array $errors = [],
        int $httpCode = 200
    ) {
        $res = [
            'status'       => 'error',
            'responseCode' => (string) $responseCode,
            'message'      => $message,
        ];

        if (!empty($errors)) {
            $res['errors'] = $errors;
        }

        return response()->json($res, $httpCode);
    }
}
